/*
  Plee the Bear

  Copyright (C) 20052011 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file player_proxy.cpp
 * \brief Automatically generated implementation for ptb::player_proxy.
 */
#include "ptb/player_proxy.hpp"

/*
                                  WARNING
                 *** This file is automatically generated. ***
             *** Do not edit. All changes will be overwritten. ***
*/

#include "ptb/player.hpp"
#include "ptb/monster.hpp"

ptb::player_proxy::player_proxy()
: m_player(NULL)
{

}

ptb::player_proxy::player_proxy( player* p )
: m_player(p)
{

}

ptb::player_proxy::player_proxy( bear::universe::physical_item* p )
: m_player( dynamic_cast<player*>(p) )
{

}

bool ptb::player_proxy::operator==( player* p ) const
{
  return m_player == p;
}

bool ptb::player_proxy::operator!=( player* p ) const
{
  return m_player != p;
}

bool ptb::player_proxy::operator==( const player_proxy& that ) const
{
  return m_player == that.m_player;
}

bool ptb::player_proxy::operator!=( const player_proxy& that ) const
{
  return m_player != that.m_player;
}

ptb::player* ptb::player_proxy::get_player_instance() const
{
  return m_player;
}

bear::universe::coordinate_type ptb::player_proxy::get_vertical_jump_force() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_vertical_jump_force();
}

bear::universe::position_type ptb::player_proxy::hot_spot() const
{
  // Automatically generated. Do not edit this file.
  return m_player->hot_spot();
}

bool ptb::player_proxy::can_throw_power(const monster::attack_type a) const
{
  // Automatically generated. Do not edit this file.
  return m_player->can_throw_power(a);
}

bool ptb::player_proxy::get_defensive_power(ptb::monster::attack_type index) const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_defensive_power(index);
}

bool ptb::player_proxy::get_offensive_phase() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_offensive_phase();
}

bool ptb::player_proxy::get_status_crouch() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_status_crouch();
}

bool ptb::player_proxy::get_status_look_upward() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_status_look_upward();
}

bool ptb::player_proxy::is_a_marionette() const
{
  // Automatically generated. Do not edit this file.
  return m_player->is_a_marionette();
}

bool ptb::player_proxy::is_clung() const
{
  // Automatically generated. Do not edit this file.
  return m_player->is_clung();
}

bool ptb::player_proxy::is_injured() const
{
  // Automatically generated. Do not edit this file.
  return m_player->is_injured();
}

bool ptb::player_proxy::is_in_offensive_phase() const
{
  // Automatically generated. Do not edit this file.
  return m_player->is_in_offensive_phase();
}

bool ptb::player_proxy::is_invincible() const
{
  // Automatically generated. Do not edit this file.
  return m_player->is_invincible();
}

bool ptb::player_proxy::is_stone_vulnerable() const
{
  // Automatically generated. Do not edit this file.
  return m_player->is_stone_vulnerable();
}

bool ptb::player_proxy::is_valid() const
{
  // Automatically generated. Do not edit this file.
  return m_player->is_valid();
}

bool ptb::player_proxy::is_vulnerable( monster& attacker ) const
{
  // Automatically generated. Do not edit this file.
  return m_player->is_vulnerable(attacker);
}

bool ptb::player_proxy::receive_an_attack( monster& attacker, bear::universe::zone::position side ) const
{
  // Automatically generated. Do not edit this file.
  return m_player->receive_an_attack(attacker, side);
}

bool ptb::player_proxy::set_u_integer_field( const std::string& name, unsigned int value ) const
{
  // Automatically generated. Do not edit this file.
  return m_player->set_u_integer_field(name, value);
}

bool ptb::player_proxy::want_clung_jump() const
{
  // Automatically generated. Do not edit this file.
  return m_player->want_clung_jump();
}

const ptb::gauge& ptb::player_proxy::get_cold_gauge() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_cold_gauge();
}

const ptb::gauge& ptb::player_proxy::get_heat_gauge() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_heat_gauge();
}

const ptb::gauge& ptb::player_proxy::get_oxygen_gauge() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_oxygen_gauge();
}

const ptb::throwable_items_container& ptb::player_proxy::get_throwable_items() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_throwable_items();
}

double ptb::player_proxy::get_energy() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_energy();
}

double ptb::player_proxy::get_jump_time_ratio() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_jump_time_ratio();
}

double ptb::player_proxy::get_max_energy() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_max_energy();
}

ptb::monster::monster_type ptb::player_proxy::get_monster_type() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_monster_type();
}

ptb::player_signals& ptb::player_proxy::get_signals() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_signals();
}

ptb::throwable_items_container& ptb::player_proxy::get_throwable_items()
{
  // Automatically generated. Do not edit this file.
  return m_player->get_throwable_items();
}

unsigned int ptb::player_proxy::get_index() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_index();
}

unsigned int ptb::player_proxy::get_monster_index() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_monster_index();
}

void ptb::player_proxy::add_air_stone(stone* s) const
{
  // Automatically generated. Do not edit this file.
  m_player->add_air_stone(s);
}

void ptb::player_proxy::add_spot_gap( const bear::universe::position_type& gap ) const
{
  // Automatically generated. Do not edit this file.
  m_player->add_spot_gap(gap);
}

void ptb::player_proxy::apply_attack() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_attack();
}

void ptb::player_proxy::apply_blast_stone() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_blast_stone();
}

void ptb::player_proxy::apply_chain() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_chain();
}

void ptb::player_proxy::apply_change_object() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_change_object();
}

void ptb::player_proxy::apply_cling() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_cling();
}

void ptb::player_proxy::apply_clung_jump() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_clung_jump();
}

void ptb::player_proxy::apply_continue_jump() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_continue_jump();
}

void ptb::player_proxy::apply_crouch() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_crouch();
}

void ptb::player_proxy::apply_die() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_die();
}

void ptb::player_proxy::apply_disappear() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_disappear();
}

void ptb::player_proxy::apply_dive() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_dive();
}

void ptb::player_proxy::apply_fall() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_fall();
}

void ptb::player_proxy::apply_float() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_float();
}

void ptb::player_proxy::apply_game_over() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_game_over();
}

void ptb::player_proxy::apply_hang() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_hang();
}

void ptb::player_proxy::apply_idle() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_idle();
}

void ptb::player_proxy::apply_impulse_jump() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_impulse_jump();
}

void ptb::player_proxy::apply_injured() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_injured();
}

void ptb::player_proxy::apply_jump() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_jump();
}

void ptb::player_proxy::apply_look_upward() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_look_upward();
}

void ptb::player_proxy::apply_maintain() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_maintain();
}

void ptb::player_proxy::apply_move_left() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_move_left();
}

void ptb::player_proxy::apply_move_right() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_move_right();
}

void ptb::player_proxy::apply_paralyze(bear::universe::time_type duration) const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_paralyze(duration);
}

void ptb::player_proxy::apply_roar() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_roar();
}

void ptb::player_proxy::apply_run() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_run();
}

void ptb::player_proxy::apply_sink() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_sink();
}

void ptb::player_proxy::apply_slap() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_slap();
}

void ptb::player_proxy::apply_start_cling() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_start_cling();
}

void ptb::player_proxy::apply_start_hang() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_start_hang();
}

void ptb::player_proxy::apply_start_jump() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_start_jump();
}

void ptb::player_proxy::apply_swim_down() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_swim_down();
}

void ptb::player_proxy::apply_swim_in_float() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_swim_in_float();
}

void ptb::player_proxy::apply_swim_jump() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_swim_jump();
}

void ptb::player_proxy::apply_swimming() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_swimming();
}

void ptb::player_proxy::apply_swim_up() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_swim_up();
}

void ptb::player_proxy::apply_swim_up_in_float() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_swim_up_in_float();
}

void ptb::player_proxy::apply_throw() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_throw();
}

void ptb::player_proxy::apply_throw_object() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_throw_object();
}

void ptb::player_proxy::apply_unchain() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_unchain();
}

void ptb::player_proxy::apply_vertical_jump() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_vertical_jump();
}

void ptb::player_proxy::apply_wait() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_wait();
}

void ptb::player_proxy::apply_walk() const
{
  // Automatically generated. Do not edit this file.
  m_player->apply_walk();
}

void ptb::player_proxy::authorize_action( const std::string& a ) const
{
  // Automatically generated. Do not edit this file.
  m_player->authorize_action(a);
}

void ptb::player_proxy::authorize_all_actions() const
{
  // Automatically generated. Do not edit this file.
  m_player->authorize_all_actions();
}

void ptb::player_proxy::balance_spot( bool x, bool y ) const
{
  // Automatically generated. Do not edit this file.
  m_player->balance_spot(x, y);
}

void ptb::player_proxy::build() const
{
  // Automatically generated. Do not edit this file.
  m_player->build();
}

void ptb::player_proxy::choose_idle_state() const
{
  // Automatically generated. Do not edit this file.
  m_player->choose_idle_state();
}

void ptb::player_proxy::choose_wait_state() const
{
  // Automatically generated. Do not edit this file.
  m_player->choose_wait_state();
}

void ptb::player_proxy::choose_walk_state() const
{
  // Automatically generated. Do not edit this file.
  m_player->choose_walk_state();
}

void ptb::player_proxy::disable_all_actions() const
{
  // Automatically generated. Do not edit this file.
  m_player->disable_all_actions();
}

void ptb::player_proxy::do_action( bear::universe::time_type elapsed_time, player_action::value_type a ) const
{
  // Automatically generated. Do not edit this file.
  m_player->do_action(elapsed_time, a);
}

void ptb::player_proxy::do_start_crouch() const
{
  // Automatically generated. Do not edit this file.
  m_player->do_start_crouch();
}

void ptb::player_proxy::do_start_look_upward() const
{
  // Automatically generated. Do not edit this file.
  m_player->do_start_look_upward();
}

void ptb::player_proxy::do_start_throw() const
{
  // Automatically generated. Do not edit this file.
  m_player->do_start_throw();
}

void ptb::player_proxy::get_visual( std::list<bear::engine::scene_visual>& visuals ) const
{
  // Automatically generated. Do not edit this file.
  m_player->get_visual(visuals);
}

void ptb::player_proxy::give_one_up() const
{
  // Automatically generated. Do not edit this file.
  m_player->give_one_up();
}

void ptb::player_proxy::pre_cache() const
{
  // Automatically generated. Do not edit this file.
  m_player->pre_cache();
}

void ptb::player_proxy::progress( bear::universe::time_type elapsed_time ) const
{
  // Automatically generated. Do not edit this file.
  m_player->progress(elapsed_time);
}

void ptb::player_proxy::receive_energy(double energy) const
{
  // Automatically generated. Do not edit this file.
  m_player->receive_energy(energy);
}

void ptb::player_proxy::receive_oxygen(double oxygen) const
{
  // Automatically generated. Do not edit this file.
  m_player->receive_oxygen(oxygen);
}

void ptb::player_proxy::remove_air_stone(stone* s) const
{
  // Automatically generated. Do not edit this file.
  m_player->remove_air_stone(s);
}

void ptb::player_proxy::remove_energy(const monster& attacker, double energy ) const
{
  // Automatically generated. Do not edit this file.
  m_player->remove_energy(attacker, energy);
}

void ptb::player_proxy::save_current_position() const
{
  // Automatically generated. Do not edit this file.
  m_player->save_current_position();
}

void ptb::player_proxy::save_position( const bear::universe::position_type& p ) const
{
  // Automatically generated. Do not edit this file.
  m_player->save_position(p);
}

void ptb::player_proxy::set_air_float(bool status) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_air_float(status);
}

void ptb::player_proxy::set_authorized_action(player_action::value_type a, bool value) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_authorized_action(a, value);
}

void ptb::player_proxy::set_can_cling(bool status) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_can_cling(status);
}

void ptb::player_proxy::set_can_throw_power(bool b, monster::attack_type a) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_can_throw_power(b, a);
}

void ptb::player_proxy::set_defensive_power(ptb::monster::attack_type index, bool statut) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_defensive_power(index, statut);
}

void ptb::player_proxy::set_energy(double energy) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_energy(energy);
}

void ptb::player_proxy::set_index( unsigned int index ) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_index(index);
}

void ptb::player_proxy::set_invincible(const bool invincible) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_invincible(invincible);
}

void ptb::player_proxy::set_marionette( bool b) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_marionette(b);
}

void ptb::player_proxy::set_max_energy(double energy) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_max_energy(energy);
}

void ptb::player_proxy::set_monster_index(unsigned int index) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_monster_index(index);
}

void ptb::player_proxy::set_monster_type(ptb::monster::monster_type m) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_monster_type(m);
}

void ptb::player_proxy::set_offensive_coefficient(ptb::monster::attack_type index, unsigned int coef) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_offensive_coefficient(index, coef);
}

void ptb::player_proxy::set_offensive_phase(const bool offensive_phase) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_offensive_phase(offensive_phase);
}

void ptb::player_proxy::set_spot_balance_move( bear::universe::coordinate_type x, bear::universe::coordinate_type y ) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_spot_balance_move(x, y);
}

void ptb::player_proxy::set_spot_maximum( bear::universe::coordinate_type x, bear::universe::coordinate_type y ) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_spot_maximum(x, y);
}

void ptb::player_proxy::set_spot_minimum( bear::universe::coordinate_type x, bear::universe::coordinate_type y ) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_spot_minimum(x, y);
}

void ptb::player_proxy::set_status_crouch(bool status) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_status_crouch(status);
}

void ptb::player_proxy::set_status_look_upward(bool status) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_status_look_upward(status);
}

void ptb::player_proxy::set_throw_down(bool value) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_throw_down(value);
}

void ptb::player_proxy::set_throw_up(bool value) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_throw_up(value);
}

void ptb::player_proxy::set_want_clung_jump(bool status) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_want_clung_jump(status);
}

void ptb::player_proxy::start_action_model(const std::string& action) const
{
  // Automatically generated. Do not edit this file.
  m_player->start_action_model(action);
}

void ptb::player_proxy::start_action( player_action::value_type a ) const
{
  // Automatically generated. Do not edit this file.
  m_player->start_action(a);
}

void ptb::player_proxy::stop_action( player_action::value_type a ) const
{
  // Automatically generated. Do not edit this file.
  m_player->stop_action(a);
}

void ptb::player_proxy::stop() const
{
  // Automatically generated. Do not edit this file.
  m_player->stop();
}

void ptb::player_proxy::throw_hazelnut() const
{
  // Automatically generated. Do not edit this file.
  m_player->throw_hazelnut();
}

void ptb::player_proxy::update_throw_time_ratio() const
{
  // Automatically generated. Do not edit this file.
  m_player->update_throw_time_ratio();
}

void ptb::player_proxy::speak( const std::vector<std::string>& speech ) const
{
  // Automatically generated. Do not edit this file.
  m_player->speak(speech);
}

void ptb::player_proxy::speak( const std::string& s ) const
{
  // Automatically generated. Do not edit this file.
  m_player->speak(s);
}

bool ptb::player_proxy::has_finished_to_chat() const
{
  // Automatically generated. Do not edit this file.
  return m_player->has_finished_to_chat();
}

bear::engine::level& ptb::player_proxy::get_level() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_level();
}

bear::engine::level_globals& ptb::player_proxy::get_level_globals() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_level_globals();
}

bool ptb::player_proxy::has_owner() const
{
  // Automatically generated. Do not edit this file.
  return m_player->has_owner();
}

const bear::universe::world& ptb::player_proxy::get_owner() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_owner();
}

bear::visual::bitmap_rendering_attributes ptb::player_proxy::get_rendering_attributes() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_rendering_attributes();
}

bool ptb::player_proxy::has_bottom_contact() const
{
  // Automatically generated. Do not edit this file.
  return m_player->has_bottom_contact();
}

bear::universe::position_type ptb::player_proxy::get_center_of_mass() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_center_of_mass();
}

bear::universe::position_type ptb::player_proxy::get_bottom_middle() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_bottom_middle();
}

bear::universe::coordinate_type ptb::player_proxy::get_horizontal_middle() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_horizontal_middle();
}

bear::universe::coordinate_type ptb::player_proxy::get_bottom() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_bottom();
}

bear::universe::coordinate_type ptb::player_proxy::get_top() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_top();
}

bear::universe::coordinate_type ptb::player_proxy::get_left() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_left();
}

bear::universe::coordinate_type ptb::player_proxy::get_right() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_right();
}

bear::universe::rectangle_type ptb::player_proxy::get_bounding_box() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_bounding_box();
}

bear::universe::speed_type ptb::player_proxy::get_speed() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_speed();
}

void ptb::player_proxy::add_internal_force( bear::universe::force_type f ) const
{
  // Automatically generated. Do not edit this file.
  m_player->add_internal_force(f);
}

void ptb::player_proxy::add_external_force( bear::universe::force_type f ) const
{
  // Automatically generated. Do not edit this file.
  m_player->add_external_force(f);
}

double ptb::player_proxy::get_mass() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_mass();
}

void ptb::player_proxy::set_mass( double m ) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_mass(m);
}

double ptb::player_proxy::get_density() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_density();
}

void ptb::player_proxy::set_density( double d ) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_density(d);
}

void ptb::player_proxy::set_system_angle( double a ) const
{
  // Automatically generated. Do not edit this file.
  m_player->set_system_angle(a);
}

std::string ptb::player_proxy::get_current_action_name() const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_current_action_name();
}

bool ptb::player_proxy::get_mark_placement( const std::string& mark_name, bear::engine::model_mark_placement& m ) const
{
  // Automatically generated. Do not edit this file.
  return m_player->get_mark_placement(mark_name, m);
}
