/* $Id: MolInfo.cpp 447995 2014-10-01 19:21:32Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seq.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>
#include <serial/enumvalues.hpp>

// generated includes
#include <objects/seq/MolInfo.hpp>
#include <util/static_map.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CMolInfo::~CMolInfo(void)
{
}

void CMolInfo::GetLabel(string* label) const
{
    // ensure label not null
    if (!label) {
        return;
    }

    // build label
    const CEnumeratedTypeValues* tv;
    string sep = label->empty() ? "" : ",";
    if (IsSetBiomol()) {
        TBiomol biomol = GetBiomol();
        tv = GetTypeInfo_enum_EBiomol();
        (*label) += sep + tv->FindName(biomol, true);
        sep = ",";
    }
    if (IsSetTech()) {
        TTech tech = GetTech();
        tv = GetTypeInfo_enum_ETech();
        (*label) += sep + tv->FindName(tech, true);
        sep = ",";
    }
    if (IsSetTechexp()) {
        (*label) += sep + GetTechexp();
        sep = ",";
    }
    if (IsSetCompleteness()) {
        TCompleteness comp = GetCompleteness();
        tv = GetTypeInfo_enum_ECompleteness();
        (*label) += sep + tv->FindName(comp, true);
    }
}


typedef SStaticPair<const char *, CMolInfo::EBiomol> TBiomolKey;

static const TBiomolKey biomol_key_to_subtype [] = {
    { " ", CMolInfo::eBiomol_unknown } ,
    { "cRNA", CMolInfo::eBiomol_cRNA },
    { "genomic", CMolInfo::eBiomol_genomic } ,
    { "genomic mRNA", CMolInfo::eBiomol_genomic_mRNA } ,
    { "mRNA [cDNA]", CMolInfo::eBiomol_mRNA } ,
    { "ncRNA", CMolInfo::eBiomol_ncRNA } ,
    { "other", CMolInfo::eBiomol_other } ,
    { "other-genetic", CMolInfo::eBiomol_other_genetic } ,
    { "peptide", CMolInfo::eBiomol_peptide } ,
    { "precursor RNA", CMolInfo::eBiomol_pre_RNA } ,
    { "rRNA", CMolInfo::eBiomol_rRNA } ,
    { "scRNA", CMolInfo::eBiomol_scRNA } ,
    { "snoRNA", CMolInfo::eBiomol_snoRNA } ,
    { "snRNA", CMolInfo::eBiomol_snRNA } ,
    { "tmRNA", CMolInfo::eBiomol_tmRNA } ,
    { "transcribed RNA", CMolInfo::eBiomol_transcribed_RNA } ,
    { "tRNA", CMolInfo::eBiomol_tRNA } ,
};

typedef CStaticPairArrayMap <const char*, CMolInfo::EBiomol, PNocase_CStr> TBiomolMap;
DEFINE_STATIC_ARRAY_MAP(TBiomolMap, sm_BiomolKeys, biomol_key_to_subtype);


string CMolInfo::GetBiomolName (CMolInfo::TBiomol biomol)
{
    string biomol_name = "";
    TBiomolMap::const_iterator g_iter = sm_BiomolKeys.begin();
    while (g_iter != sm_BiomolKeys.end() &&
           g_iter->second != biomol) {
        ++g_iter;
    }
    if (g_iter != sm_BiomolKeys.end()) {
        biomol_name = g_iter->first;
    }
    return biomol_name;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1873, CRC32: ae3bbfec */
